#include "stdafx.h"

//#include "mcelib_globals.h"
//#include "msgdef.h"
#include "tools.h"

unsigned int starttime = 0;

using namespace std;
using std::string;

void TokenizeA(const string& str,
                      vector<string>& tokens,
                      const string& delimiters)
{
    // Skip delimiters at beginning.
    string::size_type lastPos = str.find_first_not_of(delimiters, 0);
    // Find first "non-delimiter".
    string::size_type pos     = str.find_first_of(delimiters, lastPos);

    while ( (wstring::npos != pos && pos != 0xffffffff) || string::npos != lastPos)
    {
        // Found a token, add it to the vector.
        tokens.push_back(str.substr(lastPos, pos - lastPos));
        // Skip delimiters.  Note the "not_of"
        lastPos = str.find_first_not_of(delimiters, pos);
        // Find next "non-delimiter"
        pos = str.find_first_of(delimiters, lastPos);
    }
}

void TokenizeW(const wstring& str,
                      vector<wstring>& tokens,
                      const wstring& delimiters)
{
    // Skip delimiters at beginning.
    wstring::size_type lastPos = str.find_first_not_of(delimiters, 0);
    // Find first "non-delimiter".
    wstring::size_type pos     = str.find_first_of(delimiters, lastPos);

    while ( (wstring::npos != pos && pos != 0xffffffff) || string::npos != lastPos)
    {
        // Found a token, add it to the vector.
        tokens.push_back(str.substr(lastPos, pos - lastPos));
        // Skip delimiters.  Note the "not_of"
        lastPos = str.find_first_not_of(delimiters, pos);
        // Find next "non-delimiter"
        pos = str.find_first_of(delimiters, lastPos);
    }
}

struct lowercase_func {
	void operator()(std::string::value_type& v) { v = tolower(v); }
};

string make_lowercaseA(string s) {
	for_each(s.begin(), s.end(), lowercase_func());
	return s;
}

struct uppercase_func {
	void operator()(std::string::value_type& v) { v = toupper(v); }
};

string make_uppercaseA(string s) {
	for_each(s.begin(), s.end(), uppercase_func());
	return s;
}

struct lowercasew_func {
	void operator()(std::wstring::value_type& v) { v = tolower(v); }
};

wstring make_lowercaseW(wstring s) {
	for_each(s.begin(), s.end(), lowercasew_func());
	return s;
}

struct uppercasew_func {
	void operator()(std::wstring::value_type& v) { v = toupper(v); }
};

wstring make_uppercaseW(wstring s) {
	for_each(s.begin(), s.end(), uppercasew_func());
	return s;
}

wstring make_titlecase(wstring s)
{
	wstring res;
	res.reserve(s.size());

	wstring::iterator itr;
	char last = ' ';
	for (itr = s.begin() ; itr != s.end() ; itr++)
	{
		if (last == ' ' || last == '(' || last == '{' || last == '[')
		{
			res.push_back(toupper(*itr));
		} else {
			res.push_back(tolower(*itr));
		}

		last = *itr;
	}

	return res;
}

wstring str_replaceW(wstring source, wstring find, wstring replace)
{
	int srcpos = source.find(find);
	if (srcpos < 0) return source;

	wstring res = source.replace(srcpos,find.size(),replace);

	return res;
}

wstring str_replaceallW(wstring source, wstring find, wstring replace)
{
	int srcpos = source.find(find);
	while (srcpos > -1)
	{
		source = source.replace(srcpos,find.size(),replace);
		srcpos = source.find(find);
	}

	return source;
}

string str_replaceA(string source, string find, string replace)
{
	int srcpos = source.find(find);
	if (srcpos < 0) return source;

	string res = source.replace(srcpos,find.size(),replace);

	return res;
}

string str_replaceallA(string source, string find, string replace)
{
	int srcpos = source.find(find);
	while (srcpos > -1)
	{
		source = source.replace(srcpos,find.size(),replace);
		srcpos = source.find(find);
	}

	return source;
}

int GetTime()
{
	if (starttime == 0)
		starttime = timeGetTime();

	return timeGetTime() - starttime;
}

string wstrtostr(wstring wstr)
{
	string s(wstr.begin(), wstr.end());
	s.assign(wstr.begin(), wstr.end());
	return s;
}

wstring strtowstr(string str)
{
	wstring s(str.begin(), str.end());
	s.assign(str.begin(), str.end());
	return s;
}

/*
bool DirectoryInfo(string directory, vector<DI_Item>& files, vector<DI_Item>& folders, bool clear)
{
	printf("Scanning Dir %s\n",directory.c_str());
	WIN32_FIND_DATA findFileData;
	memset(&findFileData,0,sizeof(WIN32_FIND_DATA));
	string searchcmd = directory+"\\*";
	HANDLE hFind = FindFirstFile(searchcmd.c_str(), &findFileData);
	if (hFind == INVALID_HANDLE_VALUE)
		return false;

	if (clear)
	{
		files.clear();
		folders.clear();
	}
	do {
		string s = findFileData.cFileName;
		if (s == ".") continue;
		if (s == "..") continue;

		DI_Item item;
		item.Path = directory;
		item.FileName = s;
		item.attribs = findFileData.dwFileAttributes;
		if (findFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
		{
			folders.push_back(item);
		} else{
			files.push_back(item);
		}
	} while (FindNextFile(hFind, &findFileData));
	FindClose(hFind);

	return true;
}*/

wstring LastFolderW(wstring folder)
{
	if (folder.at(folder.size()-1) == L'\\')
		folder = folder.substr(0,folder.size()-1);
	folder = folder.substr(folder.rfind(L"\\")+1);

	return folder;
}

wstring FileExtW(wstring filename)
{
	int dotpos = (int)filename.rfind(L".");
	if (dotpos == 0) return L"";
	wstring lc = make_lowercaseW(filename.substr(dotpos+1));
	return lc;
}

wstring FileNoExtW(wstring filename)
{
	int dotpos = (int)filename.rfind(L".");
	if (dotpos == 0) return filename;
	return filename.substr(0,dotpos);
}

string LastFolderA(string folder)
{
	if (folder.at(folder.size()-1) == '\\')
		folder = folder.substr(0,folder.size()-1);
	folder = folder.substr(folder.rfind("\\")+1);

	return folder;
}

string FileExtA(string filename)
{
	int dotpos = (int)filename.rfind(".");
	if (dotpos == 0) return "";
	string lc = make_lowercaseA(filename.substr(dotpos+1));
	return lc;
}

string FileNoExtA(string filename)
{
	int dotpos = (int)filename.rfind(".");
	if (dotpos == 0) return filename;
	return filename.substr(0,dotpos);
}


bool isbadcharw(WCHAR in)
{
	if (in == L' ' || in == L'\t' || in == L'\r' || in == L'\n') return true;
	return false;
}

wstring TrimLeftW(wstring str) 
{
	if (str.size() == 0) return L"";
	wstring::iterator i;
	for (i = str.begin(); i != str.end(); i++) {
		if (!isbadcharw(*i)) {
			break;
		}
	}
	if (i == str.end()) {
		str.clear();
	} else {
		str.erase(str.begin(), i);
	}
	return str;
}

wstring TrimRightW(wstring str)
{
	if (str.size() == 0) return L"";
	wstring::iterator i;
	for (i = str.end() - 1; ;i--) {
		if (!isbadcharw(*i)) {
			str.erase(i + 1, str.end());
			break;
		}
		if (i == str.begin()) {
			str.clear();
			break;
		}
	}
	return str;
}

wstring TrimW(wstring s) 
{
	return TrimLeftW(TrimRightW(s));
}

bool isbadchara(WCHAR in)
{
	if (in == ' ' || in == '\t' || in == '\r' || in == '\n') return true;
	return false;
}

string TrimLeftA(string str) 
{
	if (str.size() == 0) return "";
	string::iterator i;
	for (i = str.begin(); i != str.end(); i++) {
		if (!isbadchara(*i)) {
			break;
		}
	}
	if (i == str.end()) {
		str.clear();
	} else {
		str.erase(str.begin(), i);
	}
	return str;
}

string TrimRightA(string str)
{
	if (str.size() == 0) return "";
	string::iterator i;
	for (i = str.end() - 1; ;i--) {
		if (!isbadchara(*i)) {
			str.erase(i + 1, str.end());
			break;
		}
		if (i == str.begin()) {
			str.clear();
			break;
		}
	}
	return str;
}

string TrimA(string s) 
{
	return TrimLeftA(TrimRightA(s));
}

wstring TrimRightStr(wstring str,wstring crop)
{
	if (str.size() < crop.size()) return str;
	wstring temp = str.substr(str.size()-crop.size(),crop.size());
	if (_wcsicmp(temp.c_str(),crop.c_str()) == 0)
	{
		return  str.substr(0,str.size()-crop.size());
	}	
	return str;
}

wstring sprintfaW(const WCHAR *format, ...)
{
	WCHAR temp[16384];

	va_list ap;
	va_start (ap, format);
	vswprintf_s (temp,16384, format, ap);
	va_end (ap);

	return temp;
}

string sprintfaA(const char *format, ...)
{
	char temp[16384];

	va_list ap;
	va_start (ap, format);
	vsprintf_s (temp,16384, format, ap);
	va_end (ap);

	return temp;
}

wstring mstohms(int time)
{
	int hours = 0;
	int mins = 0;
	int secs = 0;

	secs = time / 1000;
	mins = secs / 60;
	secs = secs % 60;

	hours = mins / 60;
	mins = mins % 60;

	if (hours > 0)
	{
		return sprintfa(L"%d:%02d:%02d",hours,mins,secs);
	} else {
		return sprintfa(L"%d:%02d",mins,secs);
	}
}

wstring stohms(int time)
{
	return mstohms(time * 1000);
}


int FileExistsA(string filename)
{
	return GetFileAttributesA(filename.c_str()) != 0xFFFFFFFF;
}

int FileExistsW(wstring filename)
{
	return GetFileAttributesW(filename.c_str()) != 0xFFFFFFFF;
}

wstring escape(wstring in)
{
	wstring out = L"";

	for (unsigned int i = 0 ; i < in.size() ; i++)
	{
		if (in.at(i) == L'&')
			out += L"&amp;";
		else if (in.at(i) == L'>')
			out += L"&gt;";
		else if (in.at(i) == L'<')
			out += L"&lt;";
		else if (in.at(i) == L'\'')
			out += L"&apos;";
		else if (in.at(i) == L'\"')
			out += L"&quot;";
		else 
			out += in.at(i);
	}
	return out;
}

wstring unescape(wstring in)
{
	//if (in.find("&") == in.npos) 
		return in;

	/*string out = "";

	for (unsigned int i = 0 ; i < in.size() ; i++)
	{
		if (in.at(i) == '&')
		{
			string code;
			i++;

			while (in.at(i) != ';')
			{
				code += in.at(i);
				i++;
			}

			if (code.at(0) == '#') // numerical jobby
			{
				int charcode = atoi(code.substr(1).c_str());
				char temp[2];
				temp[0] = charcode;
				temp[1] = 0;
				out.append(temp);
			} else {
				_ASSERT(FALSE);
				_ASSERT(TRUE);
			}
		}
		else 
			out += in.at(i);
	}
	return out;*/
}


const float fast_atof_table[] =	{
										0.f,
										0.1f,
										0.01f,
										0.001f,
										0.0001f,
										0.00001f,
										0.000001f,
										0.0000001f,
										0.00000001f,
										0.000000001f,
										0.0000000001f,
										0.00000000001f,
										0.000000000001f,
										0.0000000000001f,
										0.00000000000001f,
										0.000000000000001f
									};

//! Provides a fast function for converting a string into a float,
//! about 6 times faster than atof in win32.
// If you find any bugs, please send them to me, niko (at) irrlicht3d.org.
WCHAR* fast_atof_move(WCHAR* c, float& out)
{
	bool inv = false;
	WCHAR *t;
	float f;

	if (*c==L'-')
	{
		c++;
		inv = true;
	}

	f = (float)wcstol(c, &t, 10);

	c = t;

	if (*c == L'.')
	{
		c++;

		float pl = (float)wcstol(c, &t, 10);
		pl *= fast_atof_table[t-c];

		f += pl;

		c = t;

		if (*c == L'e')
		{
			++c;
			float exp = (float)wcstol(c, &t, 10);
			f *= (float)pow(10.0f, exp);
			c = t;
		}
	}

	if (inv)
		f *= -1.0f;
	
	out = f;
	return c;
}

//! Provides a fast function for converting a string into a float,
//! about 6 times faster than atof in win32.
// If you find any bugs, please send them to me, niko (at) irrlicht3d.org.
const WCHAR* fast_atof_move_const(const WCHAR* c, float& out)
{
	bool inv = false;
	WCHAR *t;
	float f;

	if (*c==L'-')
	{
		c++;
		inv = true;
	}

	f = (float)wcstol(c, &t, 10);

	c = t;

	if (*c == L'.')
	{
		c++;

		float pl = (float)wcstol(c, &t, 10);
		pl *= fast_atof_table[t-c];

		f += pl;

		c = t;

		if (*c == L'e') 
		{ 
			++c; 
			float exp = (float)wcstol(c, &t, 10); 
			f *= (float)powf(10.0f, exp); 
			c = t; 
		}
	}

	if (inv)
		f *= -1.0f;
	
	out = f;
	return c;
}


float fast_atof(const WCHAR* c)
{
	float ret;
	fast_atof_move_const(c, ret);
	return ret;
}


void GetFileStatA(string filename, int & modified, int & size)
{
	struct __stat64 buf;
	int result;
	result = _stat64( filename.c_str(), &buf );
	result = 0;
	if (result == 0)
	{
		modified = (int)buf.st_mtime;
		size = (int)(buf.st_size / 1024);
	} else {
		// TODO: file not found, but generall this is something messed up, so try to get the filesize
		modified = 0;
		size = 0;
	}
	if (modified < 0)
		modified = 0;
}

void GetFileStatW(wstring filename, int & modified, int & size)
{
	struct __stat64 buf;
	int result;
	result = _wstat64( filename.c_str(), &buf );
	result = 0;
	if (result == 0)
	{
		modified = (int)buf.st_mtime;
		size = (int)(buf.st_size / 1024);
	} else {
		// TODO: file not found, but generall this is something messed up, so try to get the filesize
		modified = 0;
		size = 0;
	}
	if (modified < 0)
		modified = 0;
}

int GetFileCreated(wstring filename)
{
	struct __stat64 buf;
	int result;
	result = _wstat64( filename.c_str(), &buf );
	result = 0;
	if (result == 0)
	{
		return (int)buf.st_ctime;
	} else {
		// TODO: file not found, but generall this is something messed up, so try to get the filesize
		return 0;
	}
}

void GetFileStatBytesW(wstring filename, int & modified, int & size)
{
	struct __stat64 buf;
	int result;
	result = _wstat64( filename.c_str(), &buf );

	if (result == 0)
	{
		modified = (int)buf.st_mtime;
		size = (int)(buf.st_size);
	} else {
		modified = 0;
		size = 0;
	}
}

void GetFileStatBytesA(string filename, int & modified, int & size)
{
	struct __stat64 buf;
	int result;
	result = _stat64( filename.c_str(), &buf );

	if (result == 0)
	{
		modified = (int)buf.st_mtime;
		size = (int)(buf.st_size);
	} else {
		modified = 0;
		size = 0;
	}
}

void FindDataToStats(WIN32_FIND_DATA* findFileData, int & size, int & modified)
{
	INT64 bsize = findFileData->nFileSizeHigh;
	bsize = bsize << 32;
	bsize += findFileData->nFileSizeLow;
	bsize = bsize / 1024;

	size = (int)bsize;

	
	INT64 bmodified = findFileData->ftLastWriteTime.dwHighDateTime;
	bmodified = bmodified << 32;
	bmodified += findFileData->ftLastWriteTime.dwLowDateTime;
	bmodified = bmodified / 10000000;
	bmodified -= 11644473600;

	modified = (int)bmodified;
}

wstring formatsize(float val, wstring type)
{
	if (val > 100)
	{
		return sprintfa(L"%0.0f %s",val,type.c_str());
	}

	return sprintfa(L"%0.1f %s",val,type.c_str());
}

/*string format_size(string in)
{
	int num = atoi(in.c_str());
	return format_size(num);
}

string format_size(int in)
{
	if (in > 1073741824) // Tb
	{
		float val = (float)in / 1073741824;
		return formatsize(val,"Tb");
	}
	if (in > 1048576) // Gb
	{
		float val = (float)in / 1048576;
		return formatsize(val,"Gb");
	}
	if (in > 1024) // Mb
	{
		float val = (float)in / 1024;
		return formatsize(val,"Mb");
	}

	return sprintfa("%d Kb",in);
}*/

bool IsFolder(wstring filename)
{
	WIN32_FIND_DATA findFileData;
	memset(&findFileData,0,sizeof(WIN32_FIND_DATA));
	HANDLE hFind = FindFirstFile(filename.c_str(), &findFileData);
	if (hFind == INVALID_HANDLE_VALUE)
	{
		FindClose(hFind);
		return false;
	}

	if (findFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
	{
		FindClose(hFind);
		return true;
	}

	FindClose(hFind);
	return false;
}

bool SortAlphabetical(const wstring left, const wstring right) 
{ 
	int res = _wcsicmp(left.c_str(),right.c_str());
	if (res < 0) return true;
	return false;
}


void outputcmd(vector<wstring> commandparts, vector<wstring>& result)
{
	result.push_back(L"<div class='h4'>Commands</div>");
	for (unsigned int i = 0 ; i < commandparts.size() ; i++)
	{
		result.push_back(commandparts.at(i) + L"<br>");
	}
}
/*
string ImageFromFolder(string path)
{
	path = make_lowercase(path);
	string * res = (string*)g_CoverCache->GetData(path);
	if (res != NULL)
		return *res;

	string temp = ImageFromFolderQuick(path);
	if (temp.size() > 0) 
		return temp;

	if (FileExists(path + "\\cover.jpg")) return "cover.jpg";
	if (FileExists(path + "\\front.jpg")) return "front.jpg";

	if (FileExists(path + "\\cd.jpg")) return "cd.jpg";
	if (FileExists(path + "\\cover.png")) return "cover.png";
	if (FileExists(path + "\\front.png")) return "front.png";
	if (FileExists(path + "\\cd.png")) return "cd.png";

	if (FileExists(path + "\\cover.gif")) return "cover.gif";
	if (FileExists(path + "\\front.gif")) return "front.gif";
	if (FileExists(path + "\\cd.gif")) return "cd.gif";

	WIN32_FIND_DATA findFileData;
	memset(&findFileData,0,sizeof(WIN32_FIND_DATA));
	string searchcmd = path+"\\*";
	HANDLE hFind = FindFirstFile(searchcmd.c_str(), &findFileData);

	string result = "";
	if (hFind != INVALID_HANDLE_VALUE)
	{
		do {
			string s = findFileData.cFileName;
			if (s == ".") continue;
			if (s == "..") continue;
			if (FileExt(s) == "jpg")
			{
				result = s;
				break;
			}
			if (FileExt(s) == "png")
			{
				result = s;
				break;
			}
			if (FileExt(s) == "gif")
			{
				result = s;
				break;
			}
		} while (FindNextFile(hFind, &findFileData));
		FindClose(hFind);
	}

	string * str = new string(result);
	g_CoverCache->SetData(path, str);


	return result;
}

string ImageFromFolderQuick(string path)
{
	path = make_lowercase(path);
	string * res = (string*)g_CoverCache->GetData(path);
	if (res != NULL)
		return *res;

	if (FileExists(path + "\\folder.jpg")) 
	{
		string * str = new string("folder.jpg");
		g_CoverCache->SetData(path, str);
		return "folder.jpg";
	}

	if (FileExists(path + "\\folder.png"))
	{
		string * str = new string("folder.png");
		g_CoverCache->SetData(path, str);
		return "folder.jpg";
	}

	if (FileExists(path + "\\folder.gif"))
	{
		string * str = new string("folder.png");
		g_CoverCache->SetData(path, str);
		return "folder.jpg";
	}

	return "";
}*/

HWND FindClient()
{
/*#ifdef _DEBUG
	return NULL;
#endif*/
	//HWND hWnd = FindWindow(WINDOWCLASS,WINDOWCLASS);
	return 0;
}

//#define PLAYERUIOVERRIDE
/*
void MinimizeClient()
{
	HWND hWnd = FindClient();
	if (!hWnd) return;

#ifdef PLAYERUIOVERRIDE
	// override players UI
	SendMessage(hWnd, WM_USER+1,1,0);
#else
	// allow player to use its own ui
	SendMessage (hWnd, WM_SYSCOMMAND, SC_MINIMIZE, 0);
	//SendMessage(hWnd, WM_USER+1,1,0);
	//ShowWindow(hWnd, SW_HIDE);
#endif
}*/
/*
void RestoreClient()
{
	HWND hWnd = FindClient();
	if (!hWnd) return;

#ifdef PLAYERUIOVERRIDE
	// override players UI
	SendMessage(hWnd, WM_USER+1,2,0);
#else
	SendMessage (hWnd, WM_SYSCOMMAND, SC_RESTORE, 0);
	//SendMessage(hWnd, WM_USER+1,2,0);
	//ShowWindow(hWnd, SW_RESTORE);
	SetForegroundWindow(hWnd);
#endif
}*/

int FilesInDir(wstring path)
{
	WIN32_FIND_DATA findFileData;
	memset(&findFileData,0,sizeof(WIN32_FIND_DATA));
	wstring searchcmd = path+L"\\*";
	HANDLE hFind = FindFirstFile(searchcmd.c_str(), &findFileData);
	if (hFind == INVALID_HANDLE_VALUE)
		return 0;

	int count = 0;

	do {
		wstring s = findFileData.cFileName;
		if (s == L".") continue;
		if (s == L"..") continue;

		count++;
		
	} while (FindNextFile(hFind, &findFileData));
	FindClose(hFind);

	return count;
}

void FileToStringA(string & result, string filename)
{
	int size;
	int modified;
	GetFileStatBytesA(filename,modified,size);

	char * buffer = new char[size+1];
	memset(buffer,0,size+1);

	result = "";
	result.reserve(size+1);
	FILE * fp;
	if (fopen_s(&fp,filename.c_str(),"r") == 0)
	{
		
		int read = fread(buffer,1,size,fp);
		buffer[read] = 0;
		result = buffer;
		fclose(fp);
	} else {
		result = "";
		if (FileExistsA(filename))
		{
			//ErrorMsg("FileToString: Failed to open file %s, but it EXISTS",filename.c_str());
		} else {
			//ErrorMsg("FileToString: Failed to open file %s, doesnt exist, why are we here?",filename.c_str());
		}
	}

	SAFE_DELETE_A( buffer );
}

void FileToStringW(wstring & result, wstring filename)
{
	int size;
	int modified;
	GetFileStatBytes(filename,modified,size);

	WCHAR * buffer = new WCHAR[size+1];
	memset(buffer,0,size+1);

	result = L"";
	result.reserve(size+1);
	FILE * fp;
	if (_wfopen_s(&fp,filename.c_str(),L"r") == 0)
	{
		
		int read = fread(buffer,1,size,fp);
		buffer[read] = 0;
		result = buffer;
		fclose(fp);
	} else {
		result = L"";
		if (FileExists(filename))
		{
			//ErrorMsg("FileToString: Failed to open file %s, but it EXISTS",filename.c_str());
		} else {
			//ErrorMsg("FileToString: Failed to open file %s, doesnt exist, why are we here?",filename.c_str());
		}
	}

	SAFE_DELETE_A( buffer );
}

void StringToFileA(string &data, string filename)
{
	FILE * fp;
	if (fopen_s(&fp,filename.c_str(),"w") == 0)
	{
		fwrite(data.c_str(),1,data.size(),fp);
		fclose(fp);
	}
}

void StringToFileW(wstring &data, wstring filename)
{
	FILE * fp;
	if (_wfopen_s(&fp,filename.c_str(),L"w") == 0)
	{
		fwrite(data.c_str(),1,data.size(),fp);
		fclose(fp);
	}
}


bool ExtInList(wstring ext, vector<wstring>* filetypes)
{
	if (!filetypes)
		return true;

	if (filetypes->size() == 0) return true;
	for (unsigned int i = 0 ; i < filetypes->size() ; i++)
	{
		if (filetypes->at(i) == ext) return true;
	}
	return false;
}

const char NumericMap[256] = 
{
    /*      0 1 2 3  4 5 6 7  8 9 A B  C D E F */
    /* 0 */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
    /* 1 */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
    /* 2 */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
    /* 3 */ 0,1,2,3, 4,5,6,7, 8,9,0,0, 0,0,0,0,
    
    /* 4 */ 0,2,2,2, 3,3,3,4, 4,4,5,5, 5,6,6,6,
    /* 5 */ 7,7,7,7, 8,8,8,9, 9,9,9,0, 0,0,0,0,
    /* 4 */ 0,2,2,2, 3,3,3,4, 4,4,5,5, 5,6,6,6,
    /* 5 */ 7,7,7,7, 8,8,8,9, 9,9,9,0, 0,0,0,0,
    
    /* 8 */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
    /* 9 */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
    /* A */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
    /* B */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
    
    /* C */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
    /* D */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
    /* E */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
    /* F */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
};

const char NumericMap2[10] = {'0','1','2','3','4','5','6','7','8','9'};

string make_numeric(string in)
{
	string result;
	result.reserve(in.size());
	char res = 0;
	for (unsigned int i = 0 ; i < in.size() ; i++)
	{
		res = NumericMap[in.at(i)];
		if (res > 0)
			result.append(1,NumericMap2[res]);
	}

	return result;
}

const char noncharnummap[256] = 
{
    /*       0  1  2  3   4  5  6  7   8  9  A  B   C  D  E  F */
    /* 0 */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
    /* 1 */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
    /* 2 */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
    /* 3 */ 1,1,2,3, 4,5,6,7, 8,9,0,0, 0,0,0,0,
    
    /* 4 */ 0,2,2,2, 3,3,3,4, 4,4,5,5, 5,6,6,6,
    /* 5 */ 7,7,7,7, 8,8,8,9, 9,9,9,0, 0,0,0,0,
    /* 4 */ 0,2,2,2, 3,3,3,4, 4,4,5,5, 5,6,6,6,
    /* 5 */ 7,7,7,7, 8,8,8,9, 9,9,9,0, 0,0,0,0,
    
    /* 8 */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
    /* 9 */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
    /* A */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
    /* B */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
    
    /* C */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
    /* D */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
    /* E */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
    /* F */ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
};


wstring replace_noncharnum(wstring in)
{
	wstring result;
	result.reserve(in.size());
	char res = 0;
	for (unsigned int i = 0 ; i < in.size() ; i++)
	{
		res = noncharnummap[in.at(i)];
		if (res > 0)
			result.append(1,in.at(i));
	}

	return result;	
}

wstring replace_numtochar(wstring in)
{
	wstring result;
	result.reserve(in.size());

	for (unsigned int i = 0 ; i < in.size() ; i++)
	{
		char curchar = in.at(i);
		switch (curchar)
		{
		case L'2':
			result.append(1,L'a');
			break;
		case L'3':
			result.append(1,L'd');
			break;
		case L'4':
			result.append(1,L'g');
			break;
		case L'5':
			result.append(1,L'j');
			break;
		case L'6':
			result.append(1,L'm');
			break;
		case L'7':
			result.append(1,L'p');
			break;
		case L'8':
			result.append(1,L't');
			break;
		case L'9':
			result.append(1,L'w');
			break;
		}
	}

	return result;	
}

wstring make_filter_label(wstring filter, wstring text)
{
	wstring result = L"";
	if (text.size() > 0)
	{
		text = replace_noncharnum(text);
		text = text.substr(0,filter.size());
		result = text;
	} else {
		result = replace_numtochar(filter);
	}

	result = make_uppercaseW(result);

	return result;
}

wstring make_filter_label_2(wstring filter)
{
	/*string result = "";
	if (text.size() > 0)
	{
		text = replace_noncharnum(text);
		text = text.substr(0,filter.size());
		result = text;
	} else {
		result = replace_numtochar(filter);
	}

	result = make_uppercase(result);*/

	return filter;
}

unsigned int MakeUID()
{
	unsigned int id;
	//rand_s(&id);
	return id;
}

wstring MakeBigUID()
{
	unsigned int id1;
	//rand_s(&id1);
	unsigned int id2;
	//rand_s(&id2);
	unsigned int id3;
	//rand_s(&id3);

	return sprintfa(L"%u-%u-%u",id1,id2,id3);
}


BOOL GetItemIdList(LPWSTR lpszPath, LPITEMIDLIST *lpItemIdList)
{
	BOOL bRetVal = FALSE;
	LPSHELLFOLDER pShellFolder = NULL;
	HRESULT hResult;
	ULONG chUsed;

	if (::SHGetDesktopFolder(&pShellFolder) != NOERROR) {
		return FALSE;
	} else {
		//ASSERT (pShellFolder);

		if (pShellFolder) {
			hResult = pShellFolder->ParseDisplayName (NULL, NULL, lpszPath, &chUsed, lpItemIdList, NULL);

			if (!FAILED (hResult)) {
				bRetVal = TRUE;
			} else {
				*lpItemIdList = NULL;
			}
		}
	}

	SAFE_RELEASE(pShellFolder);
	return bRetVal;
}

LPSHELLFOLDER pShellFolder = NULL;

void GetDriveInfo(const WCHAR * unit, DriveInfo & di)
{
	UINT unittype;

	unittype = GetDriveType(unit);

	bool showdrive = false;
	string image = "";

	int ready = 1;
	WCHAR VolumeNameBuffer[MAX_PATH+1];
	WCHAR FileSystemNameBuffer[MAX_PATH+1];
	DWORD VolumeSerialNumber;
	DWORD MaximumComponentLength;
	DWORD FileSystemFlags;

	VolumeNameBuffer[0] = 0;
	//if (unittype != 4)
	{
		ready = GetVolumeInformation(unit,(LPWSTR)VolumeNameBuffer,MAX_PATH+1,&VolumeSerialNumber,
			&MaximumComponentLength, &FileSystemFlags, (LPWSTR)FileSystemNameBuffer, MAX_PATH+1);
	}

	LPITEMIDLIST lpItemIdList1 = NULL;
	IShellItem *pShellItem1 = NULL;
	LPOLESTR pwsz = NULL;

	wstring displayname;
	if (ready > 0)
		displayname = VolumeNameBuffer;

	wstring st = unit;
	if (GetItemIdList((LPWSTR)st.c_str(), &lpItemIdList1))
	{
		STRRET sr;
		HRESULT r = pShellFolder->GetDisplayNameOf(lpItemIdList1, SHGDN_NORMAL, &sr);
		if (r == S_OK)
		{
			displayname = sr.pOleStr;			
		}
	}

    ULARGE_INTEGER FreeBytesAvailable;
    ULARGE_INTEGER TotalNumberOfBytes;
    ULARGE_INTEGER TotalNumberOfFreeBytes;

	TotalNumberOfBytes.QuadPart = 0;
	TotalNumberOfFreeBytes.QuadPart = 0;

	if (ready > 0)
		GetDiskFreeSpaceEx(unit,&FreeBytesAvailable,&TotalNumberOfBytes,&TotalNumberOfFreeBytes);

	ULONGLONG TotalNumberOfMb = TotalNumberOfBytes.QuadPart >> 20;
	ULONGLONG TotalNumberOfFreeMb = TotalNumberOfFreeBytes.QuadPart >> 20;

	di.letter = unit;
	di.desc = displayname;
	di.type = unittype;
	di.ready = ready;
	di.FreeMb = (int)TotalNumberOfFreeMb;
	di.SizeMb = (int)TotalNumberOfMb;

}

void GetDriveList(vector <DriveInfo> & results)
{
	DWORD unitmask;
	int i, n;
	WCHAR unit[4];

	SHGetDesktopFolder(&pShellFolder);

	unitmask = GetLogicalDrives();
	n = 0;
	int sortoffset = 0;
	for (i = 2; i < 26; i++)
	{
		if (unitmask & 0x1)
		{
			swprintf_s(unit, 4, L"%c:\\", L'A' + i);
			
			DriveInfo di;
			GetDriveInfo(unit, di);

			results.push_back(di);
		}
		unitmask = unitmask >> 1;
	}
}

void CleanDir(wstring source)
{
	wstring searchcmd = source + L"\\*.*";
	WIN32_FIND_DATA findFileData;
	memset(&findFileData,0,sizeof(WIN32_FIND_DATA));
	HANDLE hFind = FindFirstFile(searchcmd.c_str(), &findFileData);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		do {
			wstring s = findFileData.cFileName;
			if (s == L".") continue;
			if (s == L"..") continue;
			wstring destfile = source + L"\\" + s;
			DeleteFile(destfile.c_str());
		} while (FindNextFile(hFind, &findFileData));
		FindClose(hFind);
	}
}

#define xtod(c) ((c>='0' && c<='9') ? c-'0' : ((c>='A' && c<='F') ? \
                  c-'A'+10 : ((c>='a' && c<='f') ? c-'a'+10 : 0)))
					  
DWORD ParseHTMLColor(wstring color)
{
	color = str_replaceall(color,L"#",L"");
	if (color.size() != 6)
		return 0;

	int Red = xtod(color.at(0)) * 16 + xtod(color.at(1));
	int Green = xtod(color.at(2)) * 16 + xtod(color.at(3));
	int Blue = xtod(color.at(4)) * 16 + xtod(color.at(5));

	int Color = Red * 256 * 256 + Green * 256 + Blue;
	return Color;
}

int PickValue(map<string, int>& values, string value, int defaultval)
{
	map<string, int>::iterator itr;
	for (itr = values.begin() ; itr != values.end() ; itr++)
	{
		if ((*itr).first == value)
			return (*itr).second;
	}
	return defaultval;
}

bool HTMLYesNo(wstring text)
{
	if (make_lowercaseW(text) == L"yes")
		return true;

	if (make_lowercaseW(text) == L"true")
		return true;

	if (text == L"1")
		return true;

	return false;
}

bool FirstInFolder(wstring path, wstring filename, vector <wstring> * filetypes)
{
	// get list of files in directory to check if first or not
	vector <wstring> files;

	wprintf(L"Scanning Dir %s\n",path.c_str());
	WIN32_FIND_DATA findFileData;
	memset(&findFileData,0,sizeof(WIN32_FIND_DATA));
	wstring searchcmd = path;
	if (IsFolder(path))
		searchcmd += L"\\*";
	HANDLE hFind = FindFirstFile(searchcmd.c_str(), &findFileData);

	if (hFind != INVALID_HANDLE_VALUE)
	{
		do {
			wstring fn = findFileData.cFileName;
			if (fn == L".") continue;
			if (fn == L"..") continue;

			if (!(findFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
			{
				if (filetypes == NULL)
					files.push_back(fn);
				else if (ExtInList(FileExt(fn),filetypes))
						files.push_back(fn);
			}

		} while (FindNextFile(hFind, &findFileData));
		FindClose(hFind);
	}
	
	sort(files.begin(), files.end(),SortAlphabetical);

	if (files.size() > 0 && files.at(0) == filename)
		return true;

	return false;
}

wstring GetSpecialFolderPath(int PathID)
{
	LPITEMIDLIST pidl;
	SHGetFolderLocation (NULL,PathID,NULL,0,&pidl);
	WCHAR *temp = new WCHAR[MAX_PATH+1];
	SHGetPathFromIDList(pidl,temp);
	wstring path = temp;
	delete[] temp;

	return path;
}

wstring SortVideoTSName(wstring path, wstring filename)
{
	if (make_lowercaseW(filename) == L"video_ts.ifo")
	{
		wstring newname = LastFolder(path);
		if (make_lowercaseW(newname) == L"video_ts")
		{
			wstring folder = path;
				
			// trim trailing slash
			if (folder.at(folder.size()-1) == L'\\')
				folder = folder.substr(0,folder.size()-1);

			folder = folder.substr(0,folder.rfind(L"\\")+1);

			return LastFolder(folder);
		} else {
			return newname;
		}
	}

	return filename;
}

int gettimeofday(struct timeval *tv, struct timezone *tz)
{
  FILETIME ft;
  unsigned __int64 tmpres = 0;
  static int tzflag;
 
  if (NULL != tv)
  {
    GetSystemTimeAsFileTime(&ft);
 
    tmpres |= ft.dwHighDateTime;
    tmpres <<= 32;
    tmpres |= ft.dwLowDateTime;
 
    /*converting file time to unix epoch*/
    tmpres -= DELTA_EPOCH_IN_MICROSECS; 
    tmpres /= 10;  /*convert into microseconds*/
    tv->tv_sec = (long)(tmpres / 1000000UL);
    tv->tv_usec = (long)(tmpres % 1000000UL);
  }
 
  if (NULL != tz)
  {
    if (!tzflag)
    {
      _tzset();
      tzflag++;
    }
	long t;
	_get_timezone(&t);
    tz->tz_minuteswest = t / 60;
    _get_daylight(&(tz->tz_dsttime));
  }
 
  return 0;
}

BOOL IsDots(const WCHAR* str) {
   if(wcscmp(str,L".") && wcscmp(str,L"..")) return FALSE;
   return TRUE;
}

BOOL DeleteDirectory(const WCHAR* sPath) {
   HANDLE hFind;    // file handle
   WIN32_FIND_DATA FindFileData;
	memset(&FindFileData,0,sizeof(WIN32_FIND_DATA));

   WCHAR DirPath[MAX_PATH];
   WCHAR FileName[MAX_PATH];

   wcscpy_s(DirPath,MAX_PATH,sPath);
   wcscat_s(DirPath,MAX_PATH,L"\\*");    // searching all files
   wcscpy_s(FileName,MAX_PATH,sPath);
   wcscat_s(FileName,MAX_PATH,L"\\");

   // find the first file
   hFind = FindFirstFile(DirPath,&FindFileData);
   if(hFind == INVALID_HANDLE_VALUE) return FALSE;
   wcscpy_s(DirPath,MAX_PATH,FileName);

   bool bSearch = true;
   while(bSearch) {    // until we find an entry
      if(FindNextFile(hFind,&FindFileData)) {
         if(IsDots(FindFileData.cFileName)) continue;
         wcscat_s(FileName,MAX_PATH,FindFileData.cFileName);
         if((FindFileData.dwFileAttributes &
            FILE_ATTRIBUTE_DIRECTORY)) {

            // we have found a directory, recurse
            if(!DeleteDirectory(FileName)) {
                FindClose(hFind);
                return FALSE;    // directory couldn't be deleted
            }
            // remove the empty directory
            RemoveDirectory(FileName);
             wcscpy_s(FileName,MAX_PATH,DirPath);
         }
         else {
            if(FindFileData.dwFileAttributes &
               FILE_ATTRIBUTE_READONLY)
               // change read-only file mode
                  //_chmod(FileName, _S_IWRITE);
                  if(!DeleteFile(FileName)) {    // delete the file
                    FindClose(hFind);
                    return FALSE;
               }
               wcscpy_s(FileName,MAX_PATH,DirPath);
         }
      }
      else {
         // no more files there
         if(GetLastError() == ERROR_NO_MORE_FILES)
         bSearch = false;
         else {
            // some error occurred; close the handle and return FALSE
               FindClose(hFind);
               return FALSE;
         }

      }

   }
   FindClose(hFind);                  // close the file handle

   return RemoveDirectory(sPath);     // remove the empty directory
}

string UTF16toUTF8(const wstring & in)
{
        string out;
        unsigned int codepoint;
        bool completecode = false;
        for (wstring::const_iterator p = in.begin();  p != in.end();  ++p)
        {
                if (*p >= 0xd800 && *p <= 0xdbff)
                {
                        codepoint = ((*p - 0xd800) << 10) + 0x10000;
                        completecode = false;
                }
                else if (!completecode && *p >= 0xdc00 && *p <= 0xdfff)
                {
                        codepoint |= *p - 0xdc00;
                        completecode = true;
                }
                else
                {
                        codepoint = *p;
                        completecode = true;
                }
                if (completecode)
                {
                        if (codepoint <= 0x7f)
                                out.push_back(codepoint);
                        else if (codepoint <= 0x7ff)
                        {
                                out.push_back(0xc0 | ((codepoint >> 6) & 0x1f));
                                out.push_back(0x80 | (codepoint & 0x3f));
                        }
                        else if (codepoint <= 0xffff)
                        {
                                out.push_back(0xe0 | ((codepoint >> 12) & 0x0f));
                                out.push_back(0x80 | ((codepoint >> 6) & 0x3f));
                                out.push_back(0x80 | (codepoint & 0x3f));
                        }
                        else
                        {
                                out.push_back(0xf0 | ((codepoint >> 18) & 0x07));
                                out.push_back(0x80 | ((codepoint >> 12) & 0x3f));
                                out.push_back(0x80 | ((codepoint >> 6) & 0x3f));
                                out.push_back(0x80 | (codepoint & 0x3f));
                        }
                }
        }
        return out;
}

string DecodeHtmlA(string in)
{
	while (in.find("&") != in.npos)
	{
		string code = in.substr(in.find("&"));
		code = code.substr(0,code.find(";")+1);
		if (!code.empty())
		{
			if (code == "&amp;")
			{
				in = str_replaceA(in,code,"&");
			} else {
				in = str_replaceA(in,code,"");
			}
		} else {
			break;
		}
	}
	return in;
}

wstring DecodeHtmlW(wstring in)
{
	while (in.find(L"&") != in.npos)
	{
		wstring code = in.substr(in.find(L"&"));
		code = code.substr(0,code.find(L";")+1);
		if (!code.empty())
		{
			if (code == L"&amp;")
			{
				in = str_replace(in,code,L"&");
			} else {
				in = str_replace(in,code,L"");
			}
		} else {
			break;
		}
	}
	return in;
}

wstring DecodeHtmlW(string in)
{
	int neededbuffer = MultiByteToWideChar(CP_UTF8,0,in.c_str(),-1,NULL,0);
	if (neededbuffer == 0)
		return NULL;
	WCHAR* buf2 = new WCHAR[neededbuffer];
	memset(buf2,0,neededbuffer);
	int res = MultiByteToWideChar(CP_UTF8,0,in.c_str(),-1,buf2,neededbuffer);
	if (res == 0)
		return NULL;

	wstring result = DecodeHtmlW(buf2);
	delete buf2;
	return result;
}
